//   ==================================================================
//   >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
//   ------------------------------------------------------------------
//   Copyright (c) 2006-2011 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED 
//   ------------------------------------------------------------------
//
//   IMPORTANT: THIS FILE IS AUTO-GENERATED BY THE LATTICEMICO SYSTEM.
//
//   Permission:
//
//      Lattice Semiconductor grants permission to use this code
//      pursuant to the terms of the Lattice Semiconductor Corporation
//      Open Source License Agreement.  
//
//   Disclaimer:
//
//      Lattice Semiconductor provides no warranty regarding the use or
//      functionality of this code. It is the user's responsibility to
//      verify the users design for consistency and functionality through
//      the use of formal verification methods.
//
//   --------------------------------------------------------------------
//
//                  Lattice Semiconductor Corporation
//                  5555 NE Moore Court
//                  Hillsboro, OR 97214
//                  U.S.A
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                         503-286-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
//   --------------------------------------------------------------------
//                         FILE DETAILS
// Project          : LM32 DMA Component
// File             : slave_reg.v
// Title            : DMA Slave controller 
// Dependencies     : None
//                  :
// Version          : 7.0
//                  : Initial Release
//                  :
// Version          : 7.0SP2, 3.0
//                  : 1. Read and Write channel of DMA controller are working in 
//                  :    parallel, due to that now as soon as FIFO is not empty 
//                  :    write channel of the DMA controller start writing data 
//                  :    to the slave.
//                  : 2. Burst Size supported by DMA controller is increased to 
//                  :    support bigger burst (from current value of 4 and 8 to 
//                  :    16 and 32). Now 4 different type of burst sizes are 
//                  :    supported by the DMA controller 4, 8, 16 and 32. For 
//                  :    this Burst Size field of the control register is 
//                  :    increased to 2 bits.
//                  : 3. Glitch is removed on the S_ACK_O signal. 
//                  :
// Version          : 3.1
//                  : 1. Make DMA Engine compliant to Rule 3.100 of Wishbone Spec 
//                  :    which defines alignement of bytes in sub-word transfers.
//                  : 2. Removed glitch that did not pause the burst write when 
//                  :    the read burst was paused by the "read slave".
//                  :
// Version          : 3.2
//                  : 1. Support for 8/32-bit WISHBONE Data Bus. The Control and
//                  :    Read/Write Ports can be independently configured.
//                  : 2. Support for burst size of 64.
//                  :
// Version          : 3.3
//                  : 1. Interrupt can be release by writing 0 to IE bit in the
//                  :    status register.
// =============================================================================

`ifndef SLAVE_REG_FILE
 `define SLAVE_REG_FILE
 `include "system_conf.v"
module SLAVE_REG 
  #(parameter S_WB_DAT_WIDTH = 32,
    parameter S_WB_ADR_WIDTH = 32,
    parameter MA_WB_DAT_WIDTH = 32,
    parameter MA_WB_ADR_WIDTH = 32,
    parameter RETRY_TIMEOUT = 16,
    parameter FIFO_IMPLEMENTATION = "EBR")
   (
    input CLK_I,
    input RST_I,
    
    // Slave port
    input [S_WB_ADR_WIDTH-1:0] S_ADR_I,
    input [S_WB_DAT_WIDTH-1:0] S_DAT_I,
    input [S_WB_DAT_WIDTH/8-1:0] S_SEL_I,
    input S_WE_I,
    input S_STB_I,
    input S_CYC_I,
    input [2:0] S_CTI_I,
    output [S_WB_DAT_WIDTH-1:0] S_DAT_O,
    output reg S_ACK_O,
    output reg S_INT_O,
    
    output reg reg_start,
    input reg_status,
    input reg_interrupt,
    input reg_busy,
    output reg reg_bt3, reg_bt2, reg_bt1, reg_bt0,
    output reg reg_s_con, reg_d_con,
    output reg reg_incw, reg_inchw,
    output reg [7:0] reg_rdelay,
    output reg [31:0] reg_00_data,
    output reg [31:0] reg_04_data,
    output reg [31:0] reg_08_data
    );
   
   parameter UDLY = 1;
   
   reg [31:0] 	      reg_00_data_nxt, reg_04_data_nxt, reg_08_data_nxt;
   reg [7:0] 	      reg_0c_data, reg_0c_data_nxt;
   
   always @(/*AUTOSENSE*/reg_0c_data)
     begin
	//reg_rdelay = reg_0c_data[23:16];
	reg_rdelay = RETRY_TIMEOUT;
	reg_bt3    = reg_0c_data[7];
	reg_bt2    = reg_0c_data[6];
	reg_bt1    = reg_0c_data[5];
	reg_bt0    = reg_0c_data[4];
	reg_incw   = reg_0c_data[3];
	reg_inchw  = reg_0c_data[2];
	reg_d_con  = reg_0c_data[1];
	reg_s_con  = reg_0c_data[0];
     end
   
   reg [2:0] read_10_data;
   reg 	     reg_ie;
   always @(/*AUTOSENSE*/reg_busy or reg_ie or reg_status)
     begin
	read_10_data[2] = reg_status;
	read_10_data[1] = reg_ie;
	read_10_data[0] = reg_busy;
     end
   
   wire master_idle, reg_wr_rd, reg_wr, reg_rd;
   assign master_idle = ~reg_busy;
   assign reg_wr_rd   = S_CYC_I & S_STB_I;
   assign reg_wr      = reg_wr_rd & master_idle & S_WE_I & S_ACK_O;
   assign reg_rd      = reg_wr_rd & ~S_WE_I & S_ACK_O;
   
   reg 	s_ack_o_pre, s_ack_o_pre_nxt;
   always @(/*AUTOSENSE*/S_CYC_I or S_STB_I or S_WE_I or master_idle
	    or reg_wr_rd or s_ack_o_pre)
     begin
	if ((s_ack_o_pre == 1'b0)
	    && ((master_idle && reg_wr_rd) 
		|| ((master_idle == 1'b0) && reg_wr_rd && (S_WE_I == 1'b0))))
	  s_ack_o_pre_nxt = 1'b1;
	else
	  s_ack_o_pre_nxt = 1'b0;
	
	S_ACK_O = s_ack_o_pre && S_CYC_I && S_STB_I;
     end
   
   always @(posedge CLK_I or posedge RST_I)
     if (RST_I)
       s_ack_o_pre <= #UDLY 1'b0;
     else
       s_ack_o_pre <= #UDLY s_ack_o_pre_nxt;
   
   wire dw00_cs, dw04_cs, dw08_cs, dw0c_cs, dw10_cs;
   assign dw00_cs = (S_ADR_I[5:2] == 4'h0);
   assign dw04_cs = (S_ADR_I[5:2] == 4'h1);
   assign dw08_cs = (S_ADR_I[5:2] == 4'h2);
   assign dw0c_cs = (S_ADR_I[5:2] == 4'h3);
   assign dw10_cs = (S_ADR_I[5:2] == 4'h4);
   
   wire [31:0] S_DAT_O_int = (dw00_cs 
			      ? reg_00_data 
			      : (dw04_cs 
				 ? reg_04_data 
				 : (dw08_cs 
				    ? reg_08_data 
				    : (dw0c_cs 
				       ? {4{reg_0c_data}}
				       : (dw10_cs 
					  ? {4{5'h0,read_10_data}} 
					  : 32'h0)))));
   generate
      if (S_WB_DAT_WIDTH == 8) begin
	 
	 assign S_DAT_O = ((S_ADR_I[1:0] == 2'b00) 
			   ? S_DAT_O_int[31:24]
			   : ((S_ADR_I[1:0] == 2'b01)
			      ? S_DAT_O_int[23:16]
			      : ((S_ADR_I[1:0] == 2'b10)
				 ? S_DAT_O_int[15:8]
				 : S_DAT_O_int[7:0])));
	 
      end
      else begin
	 
	 assign S_DAT_O = S_DAT_O_int;
	 
      end
   endgenerate
   
   
   
   // Interrupt
   generate
      if (S_WB_DAT_WIDTH == 8) begin
	 
	 always @(posedge CLK_I or posedge RST_I)
	   begin
	      if(RST_I)
		S_INT_O <= #UDLY 1'b0;
	      else if(reg_interrupt && reg_ie)
		S_INT_O <= #UDLY 1'b1;
	      else if(dw10_cs && (reg_rd || (reg_wr && (S_DAT_I[1] == 1'b0))))
		S_INT_O <= #UDLY 1'b0;
	   end
	 
      end
      else begin
	 
	 always @(posedge CLK_I or posedge RST_I)
	   begin
	      if(RST_I)
		S_INT_O <= #UDLY 1'b0;
	      else if(reg_interrupt && reg_ie)
		S_INT_O <= #UDLY 1'b1;
	      else if(dw10_cs && (reg_rd || (reg_wr && (S_DAT_I[25] == 1'b0))))
		S_INT_O <= #UDLY 1'b0;
	   end
	 
      end
   endgenerate
   
   // reg_00
   generate
      if (S_WB_DAT_WIDTH == 8) begin

	 always @(/*AUTOSENSE*/S_ADR_I or S_DAT_I or dw00_cs
		  or reg_00_data or reg_wr)
	   begin
	      if (dw00_cs && reg_wr) begin
		 casez (S_ADR_I[1:0])
		   2'b00: reg_00_data_nxt = {                    S_DAT_I[7:0], reg_00_data[23: 0]};
		   2'b01: reg_00_data_nxt = {reg_00_data[31:24], S_DAT_I[7:0], reg_00_data[15: 0]};
		   2'b10: reg_00_data_nxt = {reg_00_data[31:16], S_DAT_I[7:0], reg_00_data[ 7: 0]};
		   2'b11: reg_00_data_nxt = {reg_00_data[31: 8], S_DAT_I[7:0]                    };
		   
		   default:
		     reg_00_data_nxt = reg_00_data;
		 endcase
	      end
	      else
		reg_00_data_nxt = reg_00_data;
	   end
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or S_SEL_I or dw00_cs
		  or reg_00_data or reg_wr)
	   begin
	      if (dw00_cs && reg_wr) begin
		 casez (S_SEL_I)
		   4'b1000: reg_00_data_nxt = {                    S_DAT_I[31:24], reg_00_data[23:0]};
		   4'b0100: reg_00_data_nxt = {reg_00_data[31:24], S_DAT_I[23:16], reg_00_data[15:0]};
		   4'b0010: reg_00_data_nxt = {reg_00_data[31:16], S_DAT_I[15: 8], reg_00_data[ 7:0]};
		   4'b0001: reg_00_data_nxt = {reg_00_data[31: 8], S_DAT_I[ 7: 0]                   };
		   4'b1111: reg_00_data_nxt =                      S_DAT_I[31: 0]                    ;
		   
		   default:
		     reg_00_data_nxt = reg_00_data;
		 endcase
	      end
	      else
		reg_00_data_nxt = reg_00_data;
	   end
	 
      end
   endgenerate
   
   always @(posedge CLK_I or posedge RST_I) 
     if (RST_I)
       reg_00_data <= #UDLY 32'b0;
     else
       reg_00_data <= #UDLY reg_00_data_nxt;
   
   
   
   // reg_04
   generate
      if (S_WB_DAT_WIDTH == 8) begin

	 always @(/*AUTOSENSE*/S_ADR_I or S_DAT_I or dw04_cs
		  or reg_04_data or reg_wr)
	   begin
	      if (dw04_cs && reg_wr) begin
		 casez (S_ADR_I[1:0])
		   2'b00: reg_04_data_nxt = {                    S_DAT_I[7:0], reg_04_data[23: 0]};
		   2'b01: reg_04_data_nxt = {reg_04_data[31:24], S_DAT_I[7:0], reg_04_data[15: 0]};
		   2'b10: reg_04_data_nxt = {reg_04_data[31:16], S_DAT_I[7:0], reg_04_data[ 7: 0]};
		   2'b11: reg_04_data_nxt = {reg_04_data[31: 8], S_DAT_I[7:0]                    };
		   
		   default:
		     reg_04_data_nxt = reg_04_data;
		 endcase
	      end
	      else
		reg_04_data_nxt = reg_04_data;
	   end
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or S_SEL_I or dw04_cs
		  or reg_04_data or reg_wr)
	   begin
	      if (dw04_cs && reg_wr) begin
		 casez (S_SEL_I)
		   4'b1000: reg_04_data_nxt = {                    S_DAT_I[31:24], reg_04_data[23:0]};
		   4'b0100: reg_04_data_nxt = {reg_04_data[31:24], S_DAT_I[23:16], reg_04_data[15:0]};
		   4'b0010: reg_04_data_nxt = {reg_04_data[31:16], S_DAT_I[15: 8], reg_04_data[ 7:0]};
		   4'b0001: reg_04_data_nxt = {reg_04_data[31: 8], S_DAT_I[ 7: 0]                   };
		   4'b1111: reg_04_data_nxt = {                    S_DAT_I[31: 0]                   };
		   
		   default:
		     reg_04_data_nxt = reg_04_data;
		 endcase
	      end
	      else
		reg_04_data_nxt = reg_04_data;
	   end
	 
      end
   endgenerate
   
   always @(posedge CLK_I or posedge RST_I)
     if (RST_I)
       reg_04_data <= #UDLY 32'b0;
     else
       reg_04_data <= #UDLY reg_04_data_nxt;
   
   
   
   // reg_08
   generate
      if (S_WB_DAT_WIDTH == 8) begin

	 always @(/*AUTOSENSE*/S_ADR_I or S_DAT_I or dw08_cs
		  or reg_08_data or reg_wr)
	   if (dw08_cs && reg_wr) begin
	      casez (S_ADR_I[1:0])
		2'b00: reg_08_data_nxt = {                    S_DAT_I[7:0], reg_08_data[23: 0]};
		2'b01: reg_08_data_nxt = {reg_08_data[31:24], S_DAT_I[7:0], reg_08_data[15: 0]};
		2'b10: reg_08_data_nxt = {reg_08_data[31:16], S_DAT_I[7:0], reg_08_data[ 7: 0]};
		2'b11: reg_08_data_nxt = {reg_08_data[31: 8], S_DAT_I[7:0]                    };
		
		default:
		  reg_08_data_nxt = reg_08_data;
	      endcase
	   end
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or S_SEL_I or dw08_cs
		  or reg_08_data or reg_wr)
	   if (dw08_cs && reg_wr) begin
	      casez (S_SEL_I)
		4'b1000: reg_08_data_nxt = {                    S_DAT_I[31:24], reg_08_data[23:0]};
		4'b0100: reg_08_data_nxt = {reg_08_data[31:24], S_DAT_I[23:16], reg_08_data[15:0]};
		4'b0010: reg_08_data_nxt = {reg_08_data[31:16], S_DAT_I[15: 8], reg_08_data[ 7:0]};
		4'b0001: reg_08_data_nxt = {reg_08_data[31: 8], S_DAT_I[ 7: 0]                   };
		4'b1111: reg_08_data_nxt = {                    S_DAT_I[31: 0]                   };
		
		default:
		  reg_08_data_nxt = reg_08_data;
	      endcase
	   end
	 
      end
   endgenerate
   
   always @(posedge CLK_I or posedge RST_I)
     if (RST_I)
       reg_08_data <= #UDLY 0;
     else
       reg_08_data <= #UDLY reg_08_data_nxt[31:0];
   
   
   
   // reg_0c
   generate
      if (S_WB_DAT_WIDTH == 8) begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or dw0c_cs or reg_0c_data
		  or reg_wr)
	   if (dw0c_cs && reg_wr)
	     reg_0c_data_nxt = S_DAT_I[7:0];
	   else
	     reg_0c_data_nxt = reg_0c_data;
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or S_SEL_I or dw0c_cs
		  or reg_0c_data or reg_wr)
	   if (dw0c_cs && reg_wr)
	     reg_0c_data_nxt = S_DAT_I[31:24];
	   else
	     reg_0c_data_nxt = reg_0c_data;
	 
      end
   endgenerate
   
   always @(posedge CLK_I or posedge RST_I)
     if (RST_I)
       reg_0c_data <= #UDLY 8'b0;
     else
       reg_0c_data <= #UDLY reg_0c_data_nxt;
   
   
   
   // reg_10
   reg reg_ie_nxt, reg_start_nxt;
   generate
      if (S_WB_DAT_WIDTH == 8) begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or dw10_cs or reg_ie or reg_wr)
	   if (dw10_cs && reg_wr)
	     begin
		reg_ie_nxt    = S_DAT_I[1];
		reg_start_nxt = S_DAT_I[3];
	     end
	   else
	     begin
		reg_ie_nxt    = reg_ie;
		reg_start_nxt = 1'b0;
	     end
	 
      end
      else begin
	 
	 always @(/*AUTOSENSE*/S_DAT_I or S_SEL_I or dw10_cs or reg_ie
		  or reg_wr)
	   if (dw10_cs && reg_wr)
	     begin
		reg_ie_nxt    = S_DAT_I[25];
		reg_start_nxt = S_DAT_I[27];
	     end
	   else
	     begin
		reg_ie_nxt    = reg_ie;
		reg_start_nxt = 1'b0;
	     end
	 
      end
   endgenerate
   
   always @(posedge CLK_I or posedge RST_I)
     if (RST_I)
       begin
          reg_ie    <= #UDLY 1'b0;
          reg_start <= #UDLY 1'b0;
       end
     else
       begin
          reg_ie    <= #UDLY reg_ie_nxt;
          reg_start <= #UDLY reg_start_nxt;
       end 
   
endmodule // SLAVE_REG
`endif // SLAVE_REG_FILE
