//   ==================================================================
//   >>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<
//   ------------------------------------------------------------------
//   Copyright (c) 2006-2011 by Lattice Semiconductor Corporation
//   ALL RIGHTS RESERVED 
//   ------------------------------------------------------------------
//
//   IMPORTANT: THIS FILE IS AUTO-GENERATED BY THE LATTICEMICO SYSTEM.
//
//   Permission:
//
//      Lattice Semiconductor grants permission to use this code
//      pursuant to the terms of the Lattice Semiconductor Corporation
//      Open Source License Agreement.  
//
//   Disclaimer:
//
//      Lattice Semiconductor provides no warranty regarding the use or
//      functionality of this code. It is the user's responsibility to
//      verify the users design for consistency and functionality through
//      the use of formal verification methods.
//
//   --------------------------------------------------------------------
//
//                  Lattice Semiconductor Corporation
//                  5555 NE Moore Court
//                  Hillsboro, OR 97214
//                  U.S.A
//
//                  TEL: 1-800-Lattice (USA and Canada)
//                         503-286-8001 (other locations)
//
//                  web: http://www.latticesemi.com/
//                  email: techsupport@latticesemi.com
//
//   --------------------------------------------------------------------
//                         FILE DETAILS
// Project          : LM32 DMA Component
// File             : wb_dma_ctrl.v
// Title            : DMA controller top file
// Dependencies     : None
//                  :
// Version          : 7.0
//                  : Initial Release
//                  :
// Version          : 7.0SP2, 3.0
//                  : 1. Read and Write channel of DMA controller are working in 
//                  :    parallel, due to that now as soon as FIFO is not empty 
//                  :    write channel of the DMA controller start writing data 
//                  :    to the slave.
//                  : 2. Burst Size supported by DMA controller is increased to 
//                  :    support bigger burst (from current value of 4 and 8 to 
//                  :    16 and 32). Now 4 different type of burst sizes are 
//                  :    supported by the DMA controller 4, 8, 16 and 32. For 
//                  :    this Burst Size field of the control register is 
//                  :    increased to 2 bits.
//                  : 3. Glitch is removed on the S_ACK_O signal. 
//                  :
// Version          : 3.1
//                  : Make DMA Engine compliant to Rule 3.100 of Wishbone Spec
//                  : which defines alignement of bytes in sub-word transfers.
//                  :
// Version          : 3.2
//                  : 1. Support for 8/32-bit WISHBONE Data Bus. The Control and
//                  :    Read/Write Ports can be independently configured.
//                  : 2. Support for "retry" on receipt of a WISHBONE RTY. This
//                  :    retry results in the current burst or classic cycle
//                  :    being issued again after a retry timeout.
//                  : 3. Support for "error" on receipt of a WISHBONE ERR. This
//                  :    results in the current dma transfer being terminated
//                  :    and the error is updated within the STATUS CSR.
//                  : 4. Support for burst size of 64.
// =============================================================================

`ifndef WB_DMA_CTRL_FILE
`define WB_DMA_CTRL_FILE
`include "system_conf.v"
module wb_dma_ctrl 
  #(parameter S_WB_DAT_WIDTH = 32,
    parameter S_WB_ADR_WIDTH = 32,
    parameter MA_WB_DAT_WIDTH = 32,
    parameter MA_WB_ADR_WIDTH = 32,
    parameter MB_WB_DAT_WIDTH = 32,
    parameter MB_WB_ADR_WIDTH = 32,
    parameter RETRY_TIMEOUT = 16,
    parameter FIFO_IMPLEMENTATION = "EBR")
   (
    // master read port
    output [MA_WB_ADR_WIDTH-1:0] MA_ADR_O,
    output MA_WE_O,
    output [MA_WB_DAT_WIDTH/8-1:0] MA_SEL_O,
    output MA_STB_O,
    output MA_CYC_O,
    output MA_LOCK_O,
    output [2:0] MA_CTI_O,
    output [1:0] MA_BTE_O,
    output [MA_WB_DAT_WIDTH-1:0] MA_DAT_O,
    input [MA_WB_DAT_WIDTH-1:0] MA_DAT_I,
    input MA_ACK_I,
    input MA_ERR_I,
    input MA_RTY_I,
    // master write port
    output [MB_WB_ADR_WIDTH-1:0] MB_ADR_O,
    output [MB_WB_DAT_WIDTH-1:0] MB_DAT_O,
    output MB_WE_O,
    output [MB_WB_DAT_WIDTH/8-1:0] MB_SEL_O,
    output MB_STB_O,
    output MB_CYC_O,
    output MB_LOCK_O,
    output [2:0] MB_CTI_O,
    output [1:0] MB_BTE_O,
    input [MB_WB_DAT_WIDTH-1:0] MB_DAT_I,
    input MB_ACK_I,
    input MB_ERR_I,
    input MB_RTY_I,
    // slave port
    input [S_WB_ADR_WIDTH-1:0] S_ADR_I,
    input [S_WB_DAT_WIDTH-1:0] S_DAT_I,
    input S_WE_I,
    input S_STB_I,
    input S_CYC_I,
    input [S_WB_DAT_WIDTH/8-1:0] S_SEL_I,
    input S_LOCK_I,
    input [2:0] S_CTI_I,
    input [1:0] S_BTE_I,
    output [S_WB_DAT_WIDTH-1:0] S_DAT_O,
    output S_ACK_O,
    output S_ERR_O,
    output S_RTY_O,
    output S_INT_O,
    // system clock and reset
    input CLK_I,
    input RST_I
    );
   
   assign MA_BTE_O = 0;
   assign MB_BTE_O = 0;
   assign S_ERR_O = 0;
   assign S_RTY_O = 0;
   
   wire [31:0] 	 reg_00_data;
   wire [31:0] 	 reg_04_data;
   wire [31:0] 	 reg_08_data;
   wire [7:0] 	 reg_rdelay;
   
   // slave port:master write/read data to/from register file.
   SLAVE_REG 
     #(.S_WB_DAT_WIDTH (S_WB_DAT_WIDTH),
       .S_WB_ADR_WIDTH (S_WB_ADR_WIDTH),
       .FIFO_IMPLEMENTATION (FIFO_IMPLEMENTATION)
       )
   SLAVE_REG
     (
      .S_ADR_I            (S_ADR_I        ),
      .S_DAT_I            (S_DAT_I        ),
      .S_SEL_I            (S_SEL_I        ),
      .S_WE_I             (S_WE_I         ),
      .S_STB_I            (S_STB_I        ),
      .S_CYC_I            (S_CYC_I        ),
      .S_CTI_I            (S_CTI_I        ),
      .S_DAT_O            (S_DAT_O        ),
      .S_ACK_O            (S_ACK_O        ),
      .S_INT_O            (S_INT_O        ),
      // internal signals
      .reg_start          (reg_start      ),
      .reg_status         (reg_status     ),
      .reg_interrupt      (reg_interrupt  ),
      .reg_busy           (reg_busy       ),
      .reg_bt3            (reg_bt3        ),
      .reg_bt2            (reg_bt2        ), 
      .reg_bt1            (reg_bt1        ),
      .reg_bt0            (reg_bt0        ),
      .reg_s_con          (reg_s_con      ),
      .reg_d_con          (reg_d_con      ),
      .reg_incw           (reg_incw       ),
      .reg_inchw          (reg_inchw      ),
      .reg_rdelay         (reg_rdelay     ),
      .reg_00_data        (reg_00_data    ),
      .reg_04_data        (reg_04_data    ),
      .reg_08_data        (reg_08_data    ),
      // system clock and reset
      .CLK_I              (CLK_I          ),
      .RST_I              (RST_I          )
      );
   
   // Master control
   MASTER_CTRL   
     #(.MA_WB_DAT_WIDTH (MA_WB_DAT_WIDTH),
       .MA_WB_ADR_WIDTH (MA_WB_ADR_WIDTH),
       .MB_WB_DAT_WIDTH (MB_WB_DAT_WIDTH),
       .MB_WB_ADR_WIDTH (MB_WB_ADR_WIDTH),
       .S_WB_DAT_WIDTH (S_WB_DAT_WIDTH),
       .FIFO_IMPLEMENTATION (FIFO_IMPLEMENTATION)
       )
   MASTER_CTRL
     (
      // master read port
      .MA_ADR_O           (MA_ADR_O       ),
      .MA_SEL_O           (MA_SEL_O       ),
      .MA_DAT_O           (MA_DAT_O       ),
      .MA_WE_O            (MA_WE_O        ),
      .MA_STB_O           (MA_STB_O       ),
      .MA_CYC_O           (MA_CYC_O       ),
      .MA_CTI_O           (MA_CTI_O       ),
      .MA_LOCK_O          (MA_LOCK_O      ),
      .MA_DAT_I           (MA_DAT_I       ),
      .MA_ACK_I           (MA_ACK_I       ),
      .MA_ERR_I           (MA_ERR_I       ),
      .MA_RTY_I           (MA_RTY_I       ),
      // master write port
      .MB_ADR_O           (MB_ADR_O       ),
      .MB_SEL_O           (MB_SEL_O       ),
      .MB_DAT_O           (MB_DAT_O       ),
      .MB_WE_O            (MB_WE_O        ),
      .MB_STB_O           (MB_STB_O       ),
      .MB_CYC_O           (MB_CYC_O       ),
      .MB_CTI_O           (MB_CTI_O       ),
      .MB_LOCK_O          (MB_LOCK_O      ),
      .MB_ACK_I           (MB_ACK_I       ),
      .MB_ERR_I           (MB_ERR_I       ),
      .MB_RTY_I           (MB_RTY_I       ),
      // register interface
      .reg_start          (reg_start      ),
      .reg_busy           (reg_busy       ),
      .reg_status         (reg_status     ),
      .reg_interrupt      (reg_interrupt  ),
      .reg_bt3            (reg_bt3        ),
      .reg_bt2            (reg_bt2        ),
      .reg_bt1            (reg_bt1        ),
      .reg_bt0            (reg_bt0        ),
      .reg_s_con          (reg_s_con      ),
      .reg_d_con          (reg_d_con      ),
      .reg_incw           (reg_incw       ),
      .reg_inchw          (reg_inchw      ),
      .reg_rdelay         (reg_rdelay     ),
      .reg_00_data        (reg_00_data    ),
      .reg_04_data        (reg_04_data    ),
      .reg_08_data        (reg_08_data    ),
      // system clock and reset
      .CLK_I              (CLK_I          ),
      .RST_I              (RST_I          )
      );
   
endmodule // WB_DMA_CTRL
`endif // WB_DMA_CTRL_FILE
