/*
 * t2p: Create a PDF file from the contents of one or more TIFF
 *      bilevel image files.  The images in the resulting PDF file
 *      will be compressed using ITU-T T.6 (G4) fax encoding.
 *
 * G4 encoding tables
 * $Id: pdf_g4_tables.h,v 1.2 2003/02/21 04:28:37 eric Exp $
 * Copyright 2001, 2002, 2003 Eric Smith <eric@brouhaha.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.  Note that permission is
 * not granted to redistribute this program under the terms of any
 * other version of the General Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


typedef struct
{
  uint32_t count;
  uint32_t bits;
} g4_bits;

static g4_bits g4_long_makeup_code [12] =
  {
    { 11, 0x008 },  /* 1792 */
    { 11, 0x00c },  /* 1856 */
    { 11, 0x00d },  /* 1920 */
    { 12, 0x012 },  /* 1984 */
    { 12, 0x013 },  /* 2048 */
    { 12, 0x014 },  /* 2112 */
    { 12, 0x015 },  /* 2176 */
    { 12, 0x016 },  /* 2240 */
    { 12, 0x017 },  /* 2304 */
    { 12, 0x01c },  /* 2368 */
    { 12, 0x01d },  /* 2432 */
    { 12, 0x01e }   /* 2496 */
  };

static g4_bits g4_makeup_code [2] [27] =
  {
    {
      /* white */
      { 5, 0x1b },  /* 64 */
      { 5, 0x12 },  /* 128 */
      { 6, 0x17 },  /* 192 */
      { 7, 0x37 },  /* 256 */
      { 8, 0x36 },  /* 320 */
      { 8, 0x37 },  /* 384 */
      { 8, 0x64 },  /* 448 */
      { 8, 0x65 },  /* 512 */
      { 8, 0x68 },  /* 576 */
      { 8, 0x67 },  /* 640 */
      { 9, 0x0cc }, /* 704 */
      { 9, 0x0cd }, /* 768 */
      { 9, 0x0d2 }, /* 832 */
      { 9, 0x0d3 }, /* 896 */
      { 9, 0x0d4 }, /* 960 */
      { 9, 0x0d5 }, /* 1024 */
      { 9, 0x0d6 }, /* 1088 */
      { 9, 0x0d7 }, /* 1152 */
      { 9, 0x0d8 }, /* 1216 */
      { 9, 0x0d9 }, /* 1280 */
      { 9, 0x0da }, /* 1344 */
      { 9, 0x0db }, /* 1408 */
      { 9, 0x098 }, /* 1472 */
      { 9, 0x099 }, /* 1536 */
      { 9, 0x09a }, /* 1600 */
      { 6, 0x18 },  /* 1664 */
      { 9, 0x09b }  /* 1728 */
    },
    {
      /* black */
      { 10, 0x00f },  /* 64 */
      { 12, 0x0c8 },  /* 128 */
      { 12, 0x0c9 },  /* 192 */
      { 12, 0x05b },  /* 256 */
      { 12, 0x033 },  /* 320 */
      { 12, 0x034 },  /* 384 */
      { 12, 0x035 },  /* 448 */
      { 13, 0x006c }, /* 512 */
      { 13, 0x006d }, /* 576 */
      { 13, 0x004a }, /* 640 */
      { 13, 0x004b }, /* 704 */
      { 13, 0x004c }, /* 768 */
      { 13, 0x004d }, /* 832 */
      { 13, 0x0072 }, /* 896 */
      { 13, 0x0073 }, /* 960 */
      { 13, 0x0074 }, /* 1024 */
      { 13, 0x0075 }, /* 1088 */
      { 13, 0x0076 }, /* 1152 */
      { 13, 0x0077 }, /* 1216 */
      { 13, 0x0052 }, /* 1280 */
      { 13, 0x0053 }, /* 1344 */
      { 13, 0x0054 }, /* 1408 */
      { 13, 0x0055 }, /* 1472 */
      { 13, 0x005a }, /* 1536 */
      { 13, 0x005b }, /* 1600 */
      { 13, 0x0064 }, /* 1664 */
      { 13, 0x0065 }, /* 1728 */
    }
  };


static g4_bits g4_h_code [2] [64] =
  {
    {
      /* white */
      { 8, 0x35 },  /* 0 */
      { 6, 0x07 },  /* 1 */
      { 4, 0x7 },   /* 2 */
      { 4, 0x8 },   /* 3 */
      { 4, 0xb },   /* 4 */
      { 4, 0xc },   /* 5 */
      { 4, 0xe },   /* 6 */
      { 4, 0xf },   /* 7 */
      { 5, 0x13 },  /* 8 */
      { 5, 0x14 },  /* 9 */
      { 5, 0x07 },  /* 10 */
      { 5, 0x08 },  /* 11 */
      { 6, 0x08 },  /* 12 */
      { 6, 0x03 },  /* 13 */
      { 6, 0x34 },  /* 14 */
      { 6, 0x35 },  /* 15 */
      { 6, 0x2a },  /* 16 */
      { 6, 0x2b },  /* 17 */
      { 7, 0x27 },  /* 18 */
      { 7, 0x0c },  /* 19 */
      { 7, 0x04 },  /* 20 */
      { 7, 0x17 },  /* 21 */
      { 7, 0x03 },  /* 22 */
      { 7, 0x04 },  /* 23 */
      { 7, 0x28 },  /* 24 */
      { 7, 0x2b },  /* 25 */
      { 7, 0x13 },  /* 26 */
      { 7, 0x24 },  /* 27 */
      { 7, 0x18 },  /* 28 */
      { 8, 0x02 },  /* 29 */
      { 8, 0x03 },  /* 30 */
      { 8, 0x1a },  /* 31 */
      { 8, 0x1b },  /* 32 */
      { 8, 0x12 },  /* 33 */
      { 8, 0x13 },  /* 34 */
      { 8, 0x14 },  /* 35 */
      { 8, 0x15 },  /* 36 */
      { 8, 0x16 },  /* 37 */
      { 8, 0x17 },  /* 38 */
      { 8, 0x28 },  /* 39 */
      { 8, 0x29 },  /* 40 */
      { 8, 0x2a },  /* 41 */
      { 8, 0x2b },  /* 42 */
      { 8, 0x2c },  /* 43 */
      { 8, 0x2d },  /* 44 */
      { 8, 0x04 },  /* 45 */
      { 8, 0x05 },  /* 46 */
      { 8, 0x0a },  /* 47 */
      { 8, 0x0b },  /* 48 */
      { 8, 0x52 },  /* 49 */
      { 8, 0x53 },  /* 50 */
      { 8, 0x54 },  /* 51 */
      { 8, 0x55 },  /* 52 */
      { 8, 0x24 },  /* 53 */
      { 8, 0x25 },  /* 54 */
      { 8, 0x58 },  /* 55 */
      { 8, 0x59 },  /* 56 */
      { 8, 0x5a },  /* 57 */
      { 8, 0x5b },  /* 58 */
      { 8, 0x4a },  /* 59 */
      { 8, 0x4b },  /* 60 */
      { 8, 0x32 },  /* 61 */
      { 8, 0x33 },  /* 62 */
      { 8, 0x34 }   /* 63 */
    },
    {
      /* black */
      { 10, 0x037 },  /* 0 */
      { 3, 0x2 },     /* 1 */
      { 2, 0x3 },     /* 2 */
      { 2, 0x2 },     /* 3 */
      { 3, 0x3 },     /* 4 */
      { 4, 0x3 },     /* 5 */
      { 4, 0x2 },     /* 6 */
      { 5, 0x03 },    /* 7 */
      { 6, 0x05 },    /* 8 */
      { 6, 0x04 },    /* 9 */
      { 7, 0x04 },    /* 10 */
      { 7, 0x05 },    /* 11 */
      { 7, 0x07 },    /* 12 */
      { 8, 0x04 },    /* 13 */
      { 8, 0x07 },    /* 14 */
      { 9, 0x018 },   /* 15 */
      { 10, 0x017 },  /* 16 */
      { 10, 0x018 },  /* 17 */
      { 10, 0x008 },  /* 18 */
      { 11, 0x067 },  /* 19 */
      { 11, 0x068 },  /* 20 */
      { 11, 0x06c },  /* 21 */
      { 11, 0x037 },  /* 22 */
      { 11, 0x028 },  /* 23 */
      { 11, 0x017 },  /* 24 */
      { 11, 0x018 },  /* 25 */
      { 12, 0x0ca },  /* 26 */
      { 12, 0x0cb },  /* 27 */
      { 12, 0x0cc },  /* 28 */
      { 12, 0x0cd },  /* 29 */
      { 12, 0x068 },  /* 30 */
      { 12, 0x069 },  /* 31 */
      { 12, 0x06a },  /* 32 */
      { 12, 0x06b },  /* 33 */
      { 12, 0x0d2 },  /* 34 */
      { 12, 0x0d3 },  /* 35 */
      { 12, 0x0d4 },  /* 36 */
      { 12, 0x0d5 },  /* 37 */
      { 12, 0x0d6 },  /* 38 */
      { 12, 0x0d7 },  /* 39 */
      { 12, 0x06c },  /* 40 */
      { 12, 0x06d },  /* 41 */
      { 12, 0x0da },  /* 42 */
      { 12, 0x0db },  /* 43 */
      { 12, 0x054 },  /* 44 */
      { 12, 0x055 },  /* 45 */
      { 12, 0x056 },  /* 46 */
      { 12, 0x057 },  /* 47 */
      { 12, 0x064 },  /* 48 */
      { 12, 0x065 },  /* 49 */
      { 12, 0x052 },  /* 50 */
      { 12, 0x053 },  /* 51 */
      { 12, 0x024 },  /* 52 */
      { 12, 0x037 },  /* 53 */
      { 12, 0x038 },  /* 54 */
      { 12, 0x027 },  /* 55 */
      { 12, 0x028 },  /* 56 */
      { 12, 0x058 },  /* 57 */
      { 12, 0x059 },  /* 58 */
      { 12, 0x02b },  /* 59 */
      { 12, 0x02c },  /* 60 */
      { 12, 0x05a },  /* 61 */
      { 12, 0x066 },  /* 62 */
      { 12, 0x067 }   /* 63 */
    }
  };


static g4_bits g4_vert_code [7] =
  {
    { 7, 0x02 },
    { 6, 0x02 },
    { 3, 0x02 },
    { 1, 0x01 },
    { 3, 0x03 },
    { 6, 0x03 },
    { 7, 0x03 }
  };
